using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace cifXTest
{
    public partial class cifXWatchdog : Form
    {
        private cifXUser cifXUser = new cifXUser();
        private cifxBase cifXBase = new cifxBase();

        private int iWatchdogState = 0;

        public cifXWatchdog()
        {
            InitializeComponent();
            this.txtInterval.Text = "500";
        }

        private void btnStartWatchdog_Click(object sender, EventArgs e)
        {
            ChangeState();
        }

        private void ChangeState()
        {
            UInt32 lret = 0;
            UInt32 pulTrigger = (UInt32)Convert.ToInt32(this.txtInterval.Text);
            switch (iWatchdogState)
            {
                case 0:
                    lret = cifXUser.xChannelWatchdog(cifXUser.CIFX_WATCHDOG_START, ref pulTrigger);
                    break;

                case 1:
                    break;
            }
            if (lret == 0 && iWatchdogState == 0)
                this.btnStartWatchdog.Text = "Stop Watchdog";
            else
                this.btnStartWatchdog.Text = "start Watchdog";

            this.txtError.Text = cifXBase.SetLastError(lret);
        }
    }
}